---
name: hotel-safety-check
version: 1.0.0
---

# Initialization

Hotel Safety Check for Solo Travelers - A comprehensive skill for evaluating hotel security features, conducting room inspections, and implementing personal safety protocols for solo travelers, with particular focus on solo female travelers.

## Structure

- `SKILL.md` - Main skill prompt with hotel safety evaluation frameworks

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r hotel-safety-check/ ~/.claude/skills/hotel-safety-check/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{traveler_gender}}` | `female` | Gender for tailored safety recommendations |
| `{{travel_experience_level}}` | `first-time` | Experience level (first-time, occasional, frequent, experienced) |
| `{{budget_tier}}` | `mid-range` | Budget category (budget, mid-range, luxury) |
| `{{destination_safety_level}}` | `moderate` | Destination risk profile (low, moderate, high) |
| `{{trip_duration}}` | `short` | Duration category (short, medium, long) |
| `{{feature_priority}}` | `balanced` | Prioritization approach (security-first, balanced, cost-conscious) |

## Example Usage

```
I'm a woman traveling alone to Mexico City for 5 days. This is my first solo trip
and I'm nervous about safety. I want to feel secure in my hotel but don't want to
spend more than $100/night. What specific features should I look for when booking,
and how do I evaluate a hotel's safety before reserving?
```

## Key Capabilities

1. **Physical Security Evaluation** - Assess door locks, corridors, windows, keycards
2. **Front Desk Assessment** - Evaluate 24-hour staffing, staff protocols, security presence
3. **Lighting & Visibility** - Check corridors, parking, common areas
4. **Room Location Selection** - Optimal floor and position within building
5. **Personal Security Setup** - Portable locks, daily habits, emergency preparedness
6. **Pre-Booking Research** - Chain evaluation, review analysis, direct verification
7. **Neighborhood Context** - Area safety research, transportation planning

## Core Workflows

### Pre-Booking Research
1. Identify candidate hotels (prefer major chains)
2. Analyze reviews from solo female travelers
3. Verify key features directly with hotel
4. Request room preferences in reservation
5. Compare shortlist on security features

### Room Inspection Upon Arrival
1. Accept room but verify location first
2. Inspect all door locks
3. Scan room interior (closets, curtains, under bed)
4. Check windows and balcony security
5. Set up portable security devices
6. Request change if issues found

### Nightly Security Protocol
1. Engage deadbolt and chain
2. Lock windows and balcony
3. Close curtains completely
4. Keep phone charged and accessible
5. Review emergency exit plan

---
Downloaded from [Find Skill.ai](https://findskill.ai)
