---
name: jet-lag-recovery-plan
version: 1.0.0
---

# Jet Lag Recovery Plan - Initialization

A circadian rhythm specialist skill that generates personalized jet lag recovery schedules. Creates pre-departure adaptation protocols, in-flight strategies, and arrival schedules based on Temperature Minimum (T_min) calculations and Phase Response Curve science.

## Structure

```
jet-lag-recovery-plan/
├── SKILL.md    - Main skill prompt (chronobiology specialist)
└── INIT.md     - This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r jet-lag-recovery-plan/ ~/.claude/skills/jet-lag-recovery-plan/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{origin_timezone}}` | `EST (UTC-5)` | Departure city timezone |
| `{{destination_timezone}}` | `GMT (UTC+0)` | Arrival city timezone |
| `{{usual_wake_time}}` | `7:00 AM` | Normal wake time in origin timezone |
| `{{flight_departure}}` | `2025-01-15 6:00 PM` | Flight departure date and time |
| `{{use_melatonin}}` | `yes` | Whether supplements are acceptable |
| `{{pre_adaptation_days}}` | `3` | Days available for pre-adaptation |

## Core Capabilities

1. **T_min Calculation** - Determines Temperature Minimum from wake time
2. **Phase Response Curve Application** - Eastward (advance) vs. Westward (delay)
3. **Pre-Departure Scheduling** - 1-5 day gradual adaptation plans
4. **In-Flight Protocol** - Sleep/wake timing based on destination time
5. **Light Exposure Windows** - Precise bright light and darkness periods
6. **Melatonin Timing** - Dosage and timing recommendations
7. **Troubleshooting** - Solutions for common adaptation problems

## Example Usage

```
I'm flying from San Francisco (PST) to Tokyo (JST) on March 20th,
departing at 1:00 PM. I usually wake up at 6:30 AM and go to bed
around 10:30 PM. I have 4 days before my flight to prepare.
I'm willing to use melatonin. Create a complete jet lag recovery plan.
```

## Key Concepts

- **Temperature Minimum (T_min)**: Core body temperature nadir, 2-3 hours before wake time
- **Phase Advance**: Shifting sleep earlier (Eastward travel)
- **Phase Delay**: Shifting sleep later (Westward travel)
- **Zeitgeber**: External cue that entrains biological clock (light is strongest)
- **Anchor Sleep**: Minimum 4-hour core sleep block

## Output Format

The skill generates structured plans including:
1. Travel Summary (direction, time difference, strategy)
2. Pre-Departure Schedule (day-by-day table)
3. In-Flight Protocol (sleep/wake windows)
4. Arrival Day Schedule (hour-by-hour)
5. Days 2-4 Recovery Schedule
6. Personalized Tips

## Research Foundation

Based on protocols from:
- CDC Yellow Book 2024
- Harvard Medical School/NASA (Dr. Steven Lockley)
- Huberman Lab Temperature Minimum Protocol
- British Journal of Sports Medicine (athlete protocols)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
