---
name: travel-itinerary-planner
version: 1.0.0
description: Create detailed day-by-day trip itineraries with timing, activities, packing lists, and restaurant recommendations
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This is a prompt-only skill for creating comprehensive travel itineraries. No scripts or additional files are needed - simply use SKILL.md directly with any AI assistant.

The skill helps travelers with:
- Day-by-day itinerary creation with specific timing
- Restaurant recommendations for every meal
- Destination-specific packing lists
- Budget breakdown and optimization
- Transportation guidance
- Practical travel tips

## Directory Structure

```
travel-itinerary-planner/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - the skill works directly from SKILL.md content.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r travel-itinerary-planner/ ~/.claude/skills/travel-itinerary-planner/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Start planning your trip!

## Compatibility

Tested and optimized for:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)

## Variables

Customize these for your specific trip:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{destination}}` | Paris, France | Where you're traveling to |
| `{{trip_duration}}` | 7 days | Length of your trip |
| `{{travel_dates}}` | June 15-22, 2025 | When you're traveling |
| `{{travelers}}` | couple in their 30s | Who's going on the trip |
| `{{budget}}` | $3000 total | Total or daily budget |
| `{{interests}}` | art museums, local cuisine | What you want to experience |
| `{{travel_style}}` | moderate pace | How you like to travel |

## Example Usage

After loading the skill, try prompts like:

**Full itinerary request:**
"I'm planning a 10-day trip to Japan with my wife in late March for cherry blossom season. Budget is $5000 excluding flights. We love food tours, temples, and photography. Create a day-by-day itinerary for Tokyo and Kyoto."

**Packing list request:**
"Create a packing list for a 2-week trip to Southeast Asia in August. I'll be visiting Thailand, Vietnam, and Cambodia. Include temple-appropriate clothing."

**Restaurant guide:**
"We're spending 5 days in Barcelona. Create a restaurant guide with recommendations for each meal - mix of tapas bars, seafood restaurants, and local favorites. Budget is moderate."

**Budget planning:**
"Help me create a budget breakdown for a week in London. Two adults, mid-range preferences. We want to visit major museums, see a West End show, and eat well."

## Tips for Best Results

1. **Be specific**: Include exact dates, number of travelers, and specific interests
2. **Mention constraints**: Dietary restrictions, mobility limitations, must-see items
3. **State your style**: Fast-paced or relaxed, touristy or off-beaten-path
4. **Ask for verification**: Always double-check hours, prices, and reservations
5. **Request alternatives**: Ask for backup options in case of closures or weather

---
Downloaded from [FindSkill.ai](https://findskill.ai)
