---
name: api-design-reviewer
version: 1.0.0
---

# Initialization

API Design Reviewer is an expert skill for auditing REST and GraphQL APIs to ensure consistency, scalability, security, and adherence to industry best practices. This skill helps organizations catch design flaws early, prevent costly refactoring, and maintain cohesive developer experiences across API portfolios.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive API review capabilities

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r api-design-reviewer/ ~/.claude/skills/api-design-reviewer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{api_style_guide_url}}` | `https://opensource.zalando.com/restful-api-guidelines/` | URL to organizational API style guide for validation |
| `{{pagination_default_limit}}` | `20` | Default records per page for pagination review |
| `{{max_pagination_limit}}` | `1000` | Maximum allowed records per request |
| `{{required_auth_method}}` | `oauth2` | Required authentication mechanism |
| `{{graphql_max_query_complexity}}` | `1000` | Maximum allowed GraphQL query complexity score |
| `{{rate_limit_window_seconds}}` | `3600` | Time window for rate limiting evaluation |

## Use Cases

- **Pre-deployment review**: Audit new API designs before implementation
- **Consistency audits**: Ensure naming conventions and patterns across multiple services
- **Scalability assessment**: Identify performance bottlenecks before they cause issues
- **Security review**: Catch authentication, authorization, and data exposure issues
- **Documentation validation**: Verify OpenAPI specs match implementation
- **Migration planning**: Evaluate REST to GraphQL migration feasibility

## Example Usage

```
Review this REST API design for a user management service:
GET /api/v1/users/{id}/profile

Check for consistency with RESTful naming conventions, verify
appropriate HTTP status codes, validate error response structure
follows RFC 9457 Problem Details format, and flag any security
concerns like exposed sensitive fields.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
