---
name: bereavement-grief-prompts
version: 1.0.0
---

# Initialization

Therapeutic reflection prompts specifically for processing death and loss of loved ones using continuing bonds, narrative reconstruction, and evidence-based grief frameworks.

## What This Skill Does

This skill provides specialized bereavement support through:

- **Continuing Bonds Framework**: Maintain healthy ongoing connection with deceased loved ones
- **Narrative Reconstruction**: Reauthor your life story to integrate loss
- **Memory Preservation**: Capture and honor precious memories before they fade
- **Emotional Processing**: Work through guilt, regret, relief, and complicated feelings
- **Ritual Creation**: Develop meaningful commemorative practices
- **Grief Wave Management**: Quick grounding for acute grief surges

## Differentiation

Unlike general grief skills that address all loss types (breakups, job loss, relocation), this skill focuses exclusively on **death and bereavement**—the unique challenges of permanent physical absence and continued spiritual/emotional connection.

## Structure

```
bereavement-grief-prompts/
├── SKILL.md          # Main skill prompt (copy to AI)
├── INIT.md           # This file
└── index.md          # Hugo page (website only)
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### For Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r bereavement-grief-prompts/ ~/.claude/skills/bereavement-grief-prompts/
```

Then reference in your prompts with: "Use the bereavement-grief-prompts skill"

### For ChatGPT, Gemini, Copilot

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. Paste into your AI assistant as a system prompt or initial message
4. Begin conversation with your grief processing needs

### For Custom GPT / Claude Project

1. Create new Custom GPT or Claude Project
2. Paste `SKILL.md` content into Instructions/System Prompt
3. Configure name: "Bereavement Grief Companion"
4. Optional: Add conversation starters like:
   - "I lost my mother three months ago"
   - "I need help processing complicated feelings about my father's death"
   - "Help me prepare for the anniversary of my spouse's passing"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{deceased_relationship}}` | `loved_one` | Relationship to deceased (parent, spouse, child, sibling, friend, grandparent) |
| `{{time_since_loss}}` | `months` | Time elapsed since death (acute, months, first_year, beyond_first_year, years) |
| `{{prompt_intensity}}` | `moderate` | Emotional depth (gentle, moderate, deep, clinical) |
| `{{processing_focus}}` | `balanced` | Primary focus (memory_work, continuing_bonds, meaning_making, emotional_release, future_planning) |
| `{{cultural_spiritual}}` | `secular` | Framework (secular, spiritual, religious_christian, religious_jewish, religious_muslim, eastern_philosophy, indigenous) |

## Prompt Categories Available

1. **Emotional Expression & Naming** - Identify and release grief emotions
2. **Memory Reconstruction** - Preserve sensory memories and extract legacy
3. **Continuing Bonds** - Develop ongoing connection practices
4. **Guilt, Regret & Unfinished Business** - Process complicated emotions
5. **Narrative Shift & Identity** - Reauthor identity after loss
6. **Meaning-Making & Growth** - Find purpose and integration
7. **Ritual & Commemoration** - Create sacred practices

## Workflow Templates Included

- **10-Minute Quick Processing**: Grief wave management
- **30-Minute Deep Reflection**: Dedicated processing time
- **60-Minute Comprehensive Session**: Intensive work
- **Anniversary/Trigger Preparation**: Difficult date planning

## Safety Features

The skill includes:
- Clear AI/non-therapist boundaries
- Complicated grief indicators for professional referral
- Trauma-informed language
- Cultural/spiritual sensitivity options

## Example Usage

```
User: "My mother passed away six months ago after a long illness.
I feel stuck between relief that her suffering ended and guilt
about feeling that relief. I have so many things I never said."

AI: [Uses skill to provide appropriate prompts for processing
relief/guilt ambivalence and unfinished conversations]
```

## Related Skills

- `grief-loss-processing-guide` - General loss framework (all loss types)
- `emotion-processing-journal` - Structured emotional journaling
- `cognitive-reframing-guide` - CBT thought pattern work
- `daily-emotional-check-in-partner` - Daily feeling processing

---
Downloaded from [Find Skill.ai](https://findskill.ai)
