---
name: burnout-triage
version: 1.0.0
---

# Initialization

Burnout Triage is a decision-making framework that helps severely exhausted individuals identify the ONE most critical task when experiencing burnout and decision fatigue. It cuts through overwhelm by providing clear, simple methods for identifying a single, impactful action.

## Structure

```
burnout-triage/
├── SKILL.md      # Main skill prompt (use this)
├── INIT.md       # This file - setup instructions
└── index.md      # Website listing file (not needed for usage)
```

## Files to Generate

None required. This is a prompt-only skill with no additional files, scripts, or configurations needed.

## Post-Init Steps

### Claude Code / Claude Desktop
```bash
# Copy skill to Claude skills directory
cp -r burnout-triage/ ~/.claude/skills/burnout-triage/
```

Or add to your Claude project as a custom instruction.

### ChatGPT / Custom GPTs
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your Custom GPT's instructions field
4. Save and test

### Gemini / Other AI Assistants
1. Open `SKILL.md`
2. Copy the main prompt content
3. Paste as system instructions or context
4. Adjust variables as needed in your first message

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{burnout_level}}` | `severe` | Current burnout level: mild, moderate, severe |
| `{{task_category}}` | `any` | Focus area: work, home, self-care, errands, any |
| `{{time_available}}` | `15 minutes` | How much time/energy available |
| `{{energy_level}}` | `zero` | Current energy: zero, low, moderate |
| `{{output_format}}` | `single_task` | Output: single_task, top_3_options |

## Quick Start

After installation, simply tell the AI:

> "I'm completely burnt out and have a million things to do. I have zero energy, but I need to do something. What is the ONE thing I absolutely must do today?"

The skill will:
1. Acknowledge your exhaustion with empathy
2. Quickly assess your energy level and basic needs
3. Select the appropriate triage workflow
4. Give you ONE clear, time-bounded task
5. Give you permission to stop after that one thing

## Triage Workflows Included

1. **Eisenhower Emergency** - For genuine obligations with consequences
2. **Domino Effect** - When paralyzed and needing any momentum
3. **Gift to Future Self** - To reduce tomorrow's overwhelm
4. **Body First Protocol** - When basic needs are unmet

## Key Features

- **Decision fatigue reduction**: AI makes the decision, not you
- **Energy-calibrated responses**: Adjusts based on your stated energy
- **Basic needs check**: Ensures physical needs are met first
- **Minimum viable actions**: Smallest possible step that counts
- **Self-compassion framing**: Rest IS productive
- **Crisis awareness**: Appropriate referrals for severe cases

## Example Prompts

```
"I'm overwhelmed with work and home tasks. I have about 30 minutes of energy left. What should I focus on that will make tomorrow easier?"
```

```
"I'm experiencing severe decision fatigue and can't even decide what to eat. My focus is self-care. Help me find my one thing."
```

```
"I haven't eaten or had water in hours but I have a deadline. What do I do first?"
```

## Troubleshooting

**Skill gives too many options**: Set `output_format` to `single_task` explicitly.

**Tasks suggested are too big**: Set `energy_level` to `zero` for smallest possible actions.

**Need work-specific triage**: Set `task_category` to `work`.

**AI isn't being empathetic enough**: Remind it of your burnout level explicitly.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
