---
name: core-values-clarifier
version: 1.0.0
---

# Core Values Clarifier - Initialization

Discover your authentic life values through guided psychological exploration using Schwartz theory and ACT frameworks. Align goals with what truly matters for meaningful decisions and committed action.

## Package Contents

- `SKILL.md` - Main skill prompt with complete values clarification methodology
- `INIT.md` - This initialization file

## Core Methodology

This skill uses two evidence-based psychological frameworks:

1. **Schwartz Theory of Basic Values** - 10 universal values validated across 82 countries
2. **Acceptance and Commitment Therapy (ACT)** - Values clarification and committed action

## Key Capabilities

1. **Values Discovery** - Extract authentic values through iterative questioning
2. **Values Prioritization** - Create hierarchies using forced-choice methodology
3. **Conflict Identification** - Surface tensions between competing values
4. **Values-Goal Alignment** - Map current goals to clarified values
5. **Decision Support** - Evaluate choices through values framework
6. **Personal Narrative** - Generate values statements for future reference
7. **Action Planning** - Translate values into committed behaviors

## Installation

### Claude Code

```bash
# Copy the skill to your Claude skills directory
cp -r core-values-clarifier/ ~/.claude/skills/core-values-clarifier/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt
4. Alternatively, paste the entire content at the start of a new conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{engagement_depth}}` | `moderate` | How deep to explore: quick (10 min), moderate (30 min), deep (60+ min) |
| `{{values_framework}}` | `schwartz_10` | Taxonomy to use: schwartz_10, schwartz_19, via_character, custom_list |
| `{{output_format}}` | `ranked_list_narrative` | Deliverable type: ranked_list, narrative_profile, values_statement, action_plan, all |
| `{{context_focus}}` | `general` | Life area: personal_life, professional, relationships, financial, health, general |
| `{{challenge_level}}` | `standard` | How much to probe: gentle, standard, probing |

## Quick Start

After installation, start a conversation with:

```
I've been setting goals for years but never follow through. Help me figure out what I actually value versus what I think I should value.
```

Or for a specific decision:

```
I'm facing a major career decision and want to make sure I choose based on what truly matters to me, not external pressure.
```

## The 10 Schwartz Universal Values

| Value | Core Motivation |
|-------|----------------|
| Self-Direction | Independence and freedom |
| Stimulation | Excitement and novelty |
| Hedonism | Pleasure and enjoyment |
| Achievement | Personal success |
| Power | Status and control |
| Security | Safety and stability |
| Conformity | Respecting social norms |
| Tradition | Honoring customs |
| Benevolence | Caring for close others |
| Universalism | Welfare of all people |

## Common Workflows

1. **Quick Values Discovery** (10-15 min) - Fast identification of top 3 values
2. **Deep Values Exploration** (30-60 min) - Comprehensive narrative-based discovery
3. **Values-to-Goal Alignment** (20-30 min) - Audit current goals against values
4. **Values Conflict Resolution** (20-25 min) - Resolve tension between competing values
5. **Decision Support** (15-20 min) - Evaluate specific choice using values framework

## Expected Outputs

- **Values Profile Card** - Visual summary of ranked values with personal definitions
- **Values Statement** - Concise articulation for future decision-making
- **Decision Framework** - Structured approach for evaluating choices
- **Action Plan** - Concrete behaviors aligned with each core value

## Research Foundation

Based on:
- Schwartz, S. H. (2012). An Overview of the Schwartz Theory of Basic Values
- ACT (Acceptance and Commitment Therapy) values clarification protocols
- VIA Institute on Character strengths research
- Evidence-based coaching question methodologies

## Tips for Best Results

1. **Be honest** - There are no "right" values; authentic discovery requires honesty
2. **Take your time** - Deep values work benefits from reflection, not speed
3. **Use examples** - Ground abstract values in concrete life experiences
4. **Embrace conflict** - Value tensions are normal; awareness helps navigation
5. **Return annually** - Values evolve; revisit this exploration yearly or after major life changes

---
Downloaded from [Find Skill.ai](https://findskill.ai)
