---
name: limiting-belief-reframer
version: 1.0.0
---

# Limiting Belief Reframer - Initialization

Transform self-sabotaging beliefs into empowering alternatives using CBT thought records, REBT techniques, and schema therapy for lasting cognitive change.

## What This Skill Does

The Limiting Belief Reframer helps you:

- **Surface hidden limiting beliefs** behind challenges, anxieties, and recurring patterns
- **Identify cognitive distortions** (all-or-nothing thinking, catastrophizing, mind-reading, etc.)
- **Identify deeper schemas** for persistent patterns (abandonment, defectiveness, failure, etc.)
- **Gather evidence** for and against beliefs using Socratic questioning
- **Generate believable reframes** that address the head-heart gap
- **Design behavioral experiments** to build real-world evidence
- **Track belief strength** (0-100%) over time

## Package Structure

```
limiting-belief-reframer/
├── SKILL.md   # Main skill prompt (copy this to your AI)
└── INIT.md    # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy the skill folder to your Claude skills directory
cp -r limiting-belief-reframer/ ~/.claude/skills/limiting-belief-reframer/

# The skill is now available in Claude Code
```

### Claude Projects

1. Open your Claude Project
2. Go to Project Knowledge
3. Upload `SKILL.md`
4. The skill is now available in that project

### ChatGPT Custom Instructions

1. Open `SKILL.md`
2. Copy everything after the `---` frontmatter delimiter
3. Paste into ChatGPT's Custom Instructions or a new GPT's system prompt

### Other AI Assistants (Gemini, Copilot, etc.)

1. Open `SKILL.md`
2. Copy the content after the frontmatter
3. Paste as the first message or system context

## Quick Start

After installation, try these prompts:

**Surface a limiting belief:**
```
"I got offered a leadership role but I keep thinking I'm not ready and everyone will find out I'm a fraud."
```

**Work with imposter syndrome:**
```
"I've been successful for 3 years but I still feel like I don't belong and I'll be exposed."
```

**Explore relationship fears:**
```
"My partner is being distant and I'm convinced they're going to leave me. This happens in every relationship."
```

**Address scarcity mindset:**
```
"I grew up poor and even though I make good money now, I can't spend on myself without anxiety."
```

**Deep schema work:**
```
"I have a recurring belief that I'm fundamentally flawed. It shows up in work, relationships, everything. I want to understand where it comes from."
```

## Variables

| Variable | Default | Options | Description |
|----------|---------|---------|-------------|
| `belief_depth_level` | `surface` | surface, core, schema | How deep to explore beliefs |
| `cognitive_distortion_focus` | `auto-detect` | auto-detect, user-specified, [specific distortion] | Which distortion to focus on |
| `reframe_preference` | `balanced` | evidence-based, compassionate, behavioral, balanced | Reframe style |
| `evidence_gathering_pace` | `moderate` | fast, moderate, slow | Speed of evidence exploration |
| `belief_strength_tracking` | `weekly` | daily, weekly, monthly | How often to rate belief strength |
| `therapeutic_approach` | `cbt` | cbt, rebt, schema, hybrid | Primary framework to use |

**Using variables:**
```
"Work with me using therapeutic_approach=schema and belief_depth_level=schema to explore my recurring pattern of feeling defective."
```

## Core Frameworks

### 1. The 7-Column Thought Record (CBT)

| Column | Purpose |
|--------|---------|
| 1. Situation | What triggered the thought? |
| 2. Automatic Thought | The immediate thought |
| 3. Emotion | What you felt (0-100%) |
| 4. Cognitive Distortion | Which thinking error |
| 5. Alternative Thought | Balanced reframe |
| 6. Evidence | For and against |
| 7. Outcome | New emotion, belief strength |

### 2. ABCDE Model (REBT)

- **A - Activating Event:** What happened
- **B - Belief:** Your interpretation
- **C - Consequence:** Emotional/behavioral result
- **D - Dispute:** Challenge the belief
- **E - Effective New Belief:** More helpful alternative

### 3. The 18 Early Maladaptive Schemas (Jeffrey Young)

**Disconnection & Rejection:**
1. Abandonment/Instability
2. Mistrust/Abuse
3. Emotional Deprivation
4. Defectiveness/Shame
5. Social Isolation

**Impaired Autonomy:**
6. Dependence/Incompetence
7. Vulnerability to Harm
8. Enmeshment
9. Failure

**Impaired Limits:**
10. Entitlement
11. Insufficient Self-Control

**Other-Directedness:**
12. Subjugation
13. Self-Sacrifice
14. Approval-Seeking

**Overvigilance:**
15. Negativity/Pessimism
16. Emotional Inhibition
17. Unrelenting Standards
18. Punitiveness

## The 10 Cognitive Distortions

| Distortion | Pattern | Example |
|------------|---------|---------|
| All-or-Nothing | Black-and-white categories | "If I'm not perfect, I'm a failure" |
| Catastrophizing | Assuming the worst | "This mistake will ruin everything" |
| Labeling | Global negative labels | "I'm an idiot" |
| Mind-Reading | Assuming others' thoughts | "Everyone thinks I'm incompetent" |
| Personalization | Taking excessive responsibility | "The project failed because of me" |
| Should Statements | Rigid rules | "I should never make mistakes" |
| Emotional Reasoning | Feelings as facts | "I feel like a fraud, so I am one" |
| Fortune Telling | Negative predictions | "I'll never succeed" |
| Overgeneralization | Always/never from one event | "I always mess things up" |
| Discounting Positives | Dismissing achievements | "That doesn't count" |

## Workflow Modes

| Mode | Duration | Use When |
|------|----------|----------|
| Quick Reframe | 5-10 min | Immediate relief from triggering thought |
| Deep Restructuring | 2-4 weeks | Persistent beliefs not responding to quick work |
| Schema Exploration | 4-8 weeks | Deeply ingrained childhood patterns |
| Daily Practice | Ongoing | Building automatic cognitive restructuring |

## The Head-Heart Problem

This skill specifically addresses the gap between knowing something logically and feeling it emotionally:

1. **Neutral reframes first** - "It's possible that..." not "I'm amazing!"
2. **Behavioral evidence** over affirmations
3. **Acknowledgment** that emotional belief takes time
4. **Experiments** that create felt, embodied evidence

## Important Note

This skill is a psychological tool, not a replacement for therapy. If you're experiencing:

- Suicidal thoughts or self-harm urges
- Severe depression or inability to function
- Acute mental health crisis
- Trauma requiring professional processing

Please reach out to professional resources:
- **Crisis Text Line:** Text HOME to 741741
- **National Suicide Prevention Lifeline:** 988
- **International Association for Suicide Prevention:** https://www.iasp.info/resources/Crisis_Centres/

## Related Skills

- [Negative Self-Talk Flipper](/skills/wellbeing/negative-self-talk-flipper/) - Transform harsh self-criticism into growth-oriented thoughts
- [Rejection Sensitivity Soother](/skills/wellbeing/rejection-sensitivity-soother/) - CBT/DBT for rejection sensitivity
- [Impostor Syndrome Reframer](/skills/productivity/impostor-syndrome-reframer/) - Self-doubt transformation
- [Anxiety Spirals Interrupter](/skills/productivity/anxiety-spirals-interrupter/) - Real-time anxiety intervention
- [Procrastination Root Cause Analyzer](/skills/wellbeing/procrastination-root-cause-analyzer/) - Uncover beliefs driving avoidance

## Research Foundation

Based on:
- **Cognitive Behavioral Therapy (CBT):** Aaron Beck's cognitive model and thought records
- **Rational Emotive Behavior Therapy (REBT):** Albert Ellis's ABCDE disputation model
- **Schema Therapy:** Jeffrey Young's 18 Early Maladaptive Schemas
- **Self-Compassion Research:** Kristin Neff's framework
- **Clinical AI Research:** Studies on AI-assisted cognitive restructuring effectiveness

---

## Full Skill Recreation

The following contains the complete skill content needed to recreate this skill from scratch:

### Frontmatter

```yaml
title: "Limiting Belief Reframer"
slug: limiting-belief-reframer
description: "Transform self-sabotaging beliefs into empowering alternatives using CBT thought records, REBT techniques, and schema therapy for lasting cognitive change."
categories:
  - wellbeing
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
tags:
  - limiting-beliefs
  - cbt-techniques
  - cognitive-restructuring
  - schema-therapy
  - rebt
  - self-sabotage
  - core-beliefs
  - cognitive-distortions
  - personal-growth
  - thought-records
difficulty: intermediate
time_to_implement: "45 min"
verified_working: true
rating: 4.7
variables:
  - name: "belief_depth_level"
    default: "surface"
  - name: "cognitive_distortion_focus"
    default: "auto-detect"
  - name: "reframe_preference"
    default: "balanced"
  - name: "evidence_gathering_pace"
    default: "moderate"
  - name: "belief_strength_tracking"
    default: "weekly"
  - name: "therapeutic_approach"
    default: "cbt"
```

### Core Prompt Structure

The skill uses three main frameworks:

1. **7-Column Thought Record (CBT):** Situation, Automatic Thought, Emotion, Distortion, Alternative, Evidence, Outcome

2. **ABCDE Model (REBT):** Activating Event, Belief, Consequence, Dispute, Effective New Belief

3. **Schema Therapy (Jeffrey Young):** 18 Early Maladaptive Schemas across 5 domains

### Response Process

1. **Surface the Belief:** Use discovery questions and downward arrow technique
2. **Validate and Identify:** Acknowledge emotion, name belief, identify distortions/schemas
3. **Socratic Evidence Gathering:** Ask questions, don't tell; create evidence table
4. **Generate Balanced Reframe:** Believable, first-person, addresses head-heart gap
5. **Design Behavioral Experiment:** Specific, low-stakes, testable, scheduled
6. **Track Belief Strength:** 0-100% ratings before and after

### Key Principles

- Start with empathy and validation
- Use Socratic questioning (ask more than tell)
- Start with neutral reframes, not toxic positivity
- Separate thought from identity
- Focus on behavioral experiments
- Acknowledge the head-heart gap
- Celebrate incremental progress
- Account for trauma and attachment patterns

---

Downloaded from [Find Skill.ai](https://findskill.ai)
