---
name: loneliness-reframer
version: 1.0.0
---

# Initialization

The **Loneliness Reframer** is a psychological coaching skill that helps users distinguish between healthy solitude (chosen, nourishing alone time) and genuine loneliness (distressing disconnection). Using Self-Determination Theory, CBT, and ACT, it transforms negative beliefs about being alone into empowering perspectives.

## Structure

- `SKILL.md` - Main skill prompt with assessment process, intervention pathways, thought reframing protocol, and activity prescription system

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r loneliness-reframer/ ~/.claude/skills/loneliness-reframer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the YAML frontmatter (everything after the second `---`)
3. Paste into your AI assistant as a system prompt or initial instruction

### Quick Start
After installation, start a session with:
```
I've been spending a lot of evenings alone lately. Sometimes it feels peaceful,
but other times I feel like I'm wasting my life. Can you help me figure out
what's going on?
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_situation}}` | `I'm spending the evening alone` | Your current alone-time situation to analyze |
| `{{negative_thought}}` | `I should be out socializing` | The negative thought about being alone you want to reframe |
| `{{time_available}}` | `30` | Minutes available for recommended activities |
| `{{activity_preference}}` | `mixed` | Preferred activity type: creative, physical, intellectual, contemplative, productive |
| `{{social_need_level}}` | `moderate` | Your baseline need for social connection: low, moderate, high |
| `{{autonomy_level}}` | `moderate` | How much control/choice you have over your alone time: low, moderate, high |

## Core Capabilities

1. **Differentiation Assessment** - Four-step process to identify whether current state is healthy solitude or genuine loneliness
2. **Thought Reframing** - CBT-based protocol to transform limiting beliefs (catastrophizing, should statements, mind-reading)
3. **Activity Prescription** - Personalized recommendations matched to psychological needs (autonomy, competence, relatedness)
4. **Rumination Interruption** - Grounding techniques and behavioral redirects to break negative thought cycles
5. **Scenario Handling** - Specialized guidance for common situations (weekend dread, post-social exhaustion, WFH isolation, post-relationship adjustment)

## Key Concepts

- **Solitude**: Chosen alone time with positive outcomes (85% of alone time is conscious choice)
- **Loneliness**: Distressing disconnection regardless of objective isolation
- **Self-Determination Theory**: Framework for autonomy, competence, and relatedness needs
- **Approach vs. Avoidance Motivation**: Moving toward fulfillment rather than fleeing pain
- **Behavioral Experiments**: Testing new perspectives through action, trusting data over beliefs

## Example Prompts

**Assessment:**
```
I work from home and spend most evenings alone. I keep telling myself I should
be more social, but honestly I don't know if I'm actually lonely or just think
I should be. Can you help me figure this out?
```

**Thought Reframing:**
```
I have this persistent thought that "nobody really wants to spend time with me"
even though I know it's probably not true. It keeps coming up when I'm alone on
weekends. Can you help me work through this?
```

**Activity Prescription:**
```
I have about an hour before bed and I'm feeling restless and a bit down. I don't
want to just scroll my phone. What should I do that might actually help?
```

**Scenario Help:**
```
I just went through a breakup 3 months ago and I'm not sure if the alone time
I'm having is healthy healing or if I'm isolating myself in an unhealthy way.
```

## Research Foundation

This skill draws on:
- Self-Determination Theory (Deci & Ryan) - autonomy, competence, relatedness
- CBT thought restructuring techniques
- ACT (Acceptance and Commitment Therapy) defusion
- Mindfulness-Based Stress Reduction
- 2025 research showing 85% of alone time is conscious choice and perception matters more than objective isolation

---
Downloaded from [Find Skill.ai](https://findskill.ai)
