---
name: nsdr-protocol-guide
description: Practice Non-Sleep Deep Rest and Yoga Nidra for deep relaxation, dopamine reset, and enhanced recovery. Get guided scripts for 10, 20, and 30-minute sessions.
version: 1.0.0
---

# NSDR Protocol Guide

Science-backed Non-Sleep Deep Rest protocols for energy restoration, stress relief, and enhanced cognitive function.

## What is NSDR?

NSDR (Non-Sleep Deep Rest) achieves deep relaxation without sleeping. Benefits include:
- Dopamine level restoration
- Reduced cortisol
- Enhanced learning and memory
- Partial compensation for poor sleep

## Core Protocol Elements

1. Comfortable position (lying down preferred)
2. Breath awareness (natural, uncontrolled)
3. Body scan (systematic attention through body)
4. Deepening (heaviness, warmth, floating)
5. Gentle return (gradual awakening)

## Session Types

- **Quick NSDR (10 min)** - Midday energy boost
- **Standard NSDR (20 min)** - Full restoration
- **Deep NSDR (30 min)** - Complete reset
- **Sleep Prep NSDR** - Transition to sleep
- **Learning NSDR** - Post-study memory consolidation

## Best Times to Practice

- Morning: Enhanced learning capacity
- Early afternoon (1-3pm): Energy restoration
- After studying: Memory consolidation
- Evening: Stress release
- Before bed: Sleep preparation

---
Downloaded from [Find Skill.ai](https://findskill.ai)
