---
name: procrastination-root-cause-analyzer
version: 1.0.0
---

# Procrastination Root Cause Analyzer - Initialization

A diagnostic framework that identifies the underlying psychological, cognitive, behavioral, and environmental factors driving procrastination patterns, then provides personalized, evidence-based interventions matched to specific cause profiles.

## What This Skill Does

- Diagnoses which of 5 procrastination types apply to you
- Maps surface behaviors to deeper psychological drivers
- Assesses emotion regulation, perfectionism, fear, and ADHD factors
- Matches interventions to your specific root cause profile
- Provides immediate action plans and long-term strategies

## Structure

```
procrastination-root-cause-analyzer/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude skills directory
cp -r procrastination-root-cause-analyzer/ ~/.claude/skills/procrastination-root-cause-analyzer/
```

### ChatGPT / Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instructions
4. Start a conversation describing your procrastination situation

## Quick Start

After installation, start with a prompt like:

```
I have a research paper due in 5 days. I've known about it for 3 weeks
but haven't started. Every time I think about it, I feel pressure to
write something brilliant and I just freeze. Help me figure out what's
really going on.
```

The AI will:
1. Ask diagnostic questions about your emotions, thoughts, and patterns
2. Identify your primary procrastination type (emotion regulation, perfectionism, fear, overwhelm, or ADHD-related)
3. Explain why common advice fails for your type
4. Provide matched interventions with an immediate action plan

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `procrastination_severity_threshold` | `6` | Severity (1-10) at which professional support is recommended |
| `intervention_focus_primary` | `emotion_regulation` | Primary intervention target type |
| `time_to_deadline_days` | `7` | Days until deadline for urgency calibration |
| `emotional_intensity_scale` | `medium` | Emotional response intensity (low/medium/high) |
| `task_clarity_level` | `vague` | Task definition clarity (vague/moderate/concrete) |
| `adhd_likelihood_screening` | `false` | Include ADHD-specific interventions |

## The Five Procrastination Types

1. **Emotion Regulation** - Avoiding negative emotions; "I don't feel like it"
2. **Perfectionism** - Fear of imperfection; "If I can't do it perfectly, why start?"
3. **Fear-Based** - Fear of failure or success; avoidance of high-stakes tasks
4. **Overwhelm** - Task complexity; "I don't know where to begin"
5. **ADHD-Related** - Executive function issues; time blindness, task initiation failure

## Key Interventions by Type

| Type | Primary Interventions |
|------|----------------------|
| Emotion Regulation | Affect labeling, opposite action, reward bridging |
| Perfectionism | 70% rule, deliberate imperfection exposure, cognitive restructuring |
| Fear-Based | Catastrophe deconstruction, exposure hierarchy, success visualization |
| Overwhelm | Radical task breakdown, next action method, timeboxing |
| ADHD-Related | External structure, environment design, implementation intentions |

## Research Foundation

Based on:
- Temporal Motivation Theory (Piers Steel)
- Emotion regulation frameworks
- CBT meta-analysis showing most effective interventions
- 2025 research on affect labeling and subgoal generation

## Example Diagnostic Output

```
PRIMARY TYPE: Perfectionism-driven with emotion regulation secondary

ROOT CAUSE: Fear of imperfection creating paralysis; waiting for
"perfect conditions" that never arrive

EVIDENCE FROM YOUR RESPONSES:
- "I freeze when I think about it" → Fear response
- "Pressure to write something brilliant" → Perfectionism
- "Scrolling for hours" → Emotion regulation through distraction

INTERVENTION PLAN:

IMMEDIATE (next hour):
- Open document, write ONE imperfect sentence
- Implementation intention: "At 3pm, I close all tabs and write one bad paragraph"

TODAY:
- 2 pomodoros (25 min each) with explicit permission to write badly
- Affect labeling before each: "I feel anxious, and I'm starting anyway"

THIS WEEK:
- Mon-Wed: 500 words/day (quality irrelevant)
- Thursday: Review and revise
- Friday: Final polish

MEASUREMENT: If this works, you'll notice less anxiety AFTER starting
(the fear is about starting, not doing)
```

## When to Seek Professional Help

This skill recommends professional support when:
- Severity rating 8+ out of 10
- Major life impairment (job loss, relationship damage)
- Co-occurring depression, anxiety, or ADHD symptoms
- Multiple failed attempts at change
- Feelings of hopelessness

## Related Skills

- Anxiety Spirals Interrupter
- Cognitive Reframing Guide
- Habit Tracker
- Goal Framework Strategist
- Stress Management
- Burnout Triage

---
Downloaded from [Find Skill.ai](https://findskill.ai)
