---
name: self-compassion-coach
version: 1.0.0
description: Replace perfectionism with Kristin Neff's research-backed self-compassion framework
author: FindSkill.ai
license: MIT
---

# Initialization

The Self-Compassion Coach helps users replace harsh perfectionism and self-criticism with Kristin Neff's empirically validated self-compassion framework. It provides structured techniques for acute distress, chronic patterns, and skill-building.

## Overview

This is a **prompt-only skill** with no scripts to generate. The skill content is contained entirely within SKILL.md.

**What this skill provides:**
- Three-component self-compassion framework (self-kindness, common humanity, mindfulness)
- Yin (tender) and Yang (fierce) self-compassion balancing
- Self-Compassion Break technique for acute distress
- Inner Critic Translation process
- Perfectionism reframe methodology
- Backdraft handling for resistance
- Daily micro-exercises
- Session structures for different needs

**Time to initialize:** ~1 minute (just copy the prompt)

## Directory Structure

```
self-compassion-coach/
├── SKILL.md    # Main skill instructions and framework
└── INIT.md     # This initialization manifest
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None (prompt-only skill).

## Post-Init Steps

### Claude Code Users

```bash
# Copy to your skills directory
cp -r self-compassion-coach/ ~/.claude/skills/self-compassion-coach/
```

Then reference the skill in your Claude Code sessions.

### Other AI Assistants (ChatGPT, Gemini, Copilot, etc.)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or directly in chat
4. Start your self-compassion coaching session

## Compatibility

Tested with:
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Advanced)
- Copilot
- Any other conversational AI

## Variables

Customize these settings by mentioning them in your initial prompt:

| Variable | Default | Description |
|----------|---------|-------------|
| `compassion_style` | `balanced` | Mix of Yin (soothing) and Yang (motivating) responses |
| `critic_intensity` | `moderate` | Your inner critic harshness: mild, moderate, severe |
| `perfectionism_type` | `mixed` | Pattern: evaluative_concerns, strivings, or mixed |
| `experience_level` | `beginner` | Familiarity: beginner, intermediate, advanced |
| `somatic_cue` | `hand_on_heart` | Preferred grounding: hand_on_heart, breath, feet_on_floor, self_hug |

**Example customization prompt:**
"I have a severe inner critic and I'm a complete beginner to self-compassion. I prefer grounding through my breath rather than touch. Can you help me with something that happened at work today?"

## Quick Start Examples

### Acute Distress
```
"I just got criticized by my boss in front of my team. I can't stop thinking about how stupid I am. Help me through this using Kristin Neff's Self-Compassion Break."
```

### Chronic Perfectionism
```
"I've been procrastinating on a big project because I'm terrified it won't be perfect. My inner critic keeps calling me lazy and useless. Can you help me understand what's happening and how to move forward?"
```

### Skill Building
```
"I want to build a daily self-compassion practice. I've read about Kristin Neff's work but I don't know where to start. Can you guide me through some exercises?"
```

### Yang (Fierce) Compassion
```
"I've been letting a toxic coworker walk all over me because I don't want to cause conflict. I need help finding the courage to set boundaries."
```

## Framework Reference

### The Three Components

1. **Self-Kindness** (vs. Self-Judgment): Warmth and understanding toward self when suffering
2. **Common Humanity** (vs. Isolation): Recognizing struggle as shared human experience
3. **Mindfulness** (vs. Over-Identification): Balanced awareness of emotions without drowning in them

### Self-Compassion Break

Three phrases + physical anchor:
1. "This is a moment of suffering" (Mindfulness)
2. "Suffering is part of being human" (Common Humanity)
3. "May I be kind to myself" (Self-Kindness)
+ Hand on heart or soothing touch

### Yin vs. Yang

| Yin (Tender) | Yang (Fierce) |
|--------------|---------------|
| Soothing | Protecting |
| Validating | Motivating |
| Comforting | Boundary-setting |
| Being with pain | Taking action |

## Research Foundation

This skill is based on peer-reviewed research by Dr. Kristin Neff and colleagues:
- Self-Compassion Scale (SCS) validation studies
- Mindful Self-Compassion (MSC) program research
- RCTs showing self-compassion reduces maladaptive perfectionism
- Studies demonstrating self-compassion maintains or increases motivation

Key sources:
- Neff, K. D. (2003). Self-compassion: An alternative conceptualization of a healthy attitude toward oneself
- Neff, K. D., & Knox, M. C. (2017). Self-compassion components
- Ferrari et al. (2019). Self-compassion interventions for perfectionism

---
Downloaded from [Find Skill.ai](https://findskill.ai)
