---
name: work-life-balance-auditor
version: 1.0.0
---

# Initialization

Work-Life Balance Auditor analyzes how you allocate time across work, personal, and wellness domains, then provides data-driven insights and personalized rebalancing recommendations to prevent burnout.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive WLB audit methodology

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r work-life-balance-auditor/ ~/.claude/skills/work-life-balance-auditor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{work_hours_per_week}}` | `45` | Target weekly work hours considered sustainable |
| `{{sleep_hours_per_night}}` | `7.5` | Minimum sleep target per night (7-9 hrs evidence-based) |
| `{{burnout_risk_threshold}}` | `0.7` | Demands/resources ratio for 'at risk' classification |
| `{{core_boundaries_config}}` | `work_end: 18:00, email_free_evenings: 5, disconnect_days: Sat-Sun` | Non-negotiable boundary rules |
| `{{rebalancing_pace}}` | `moderate` | Implementation speed: aggressive, moderate, conservative |
| `{{life_domains_to_optimize}}` | `sleep, exercise, relationships, relaxation` | Priority domains for rebalancing |

## Key Capabilities

1. **Time Allocation Audit** - Collect weekly time logs, categorize activities, visualize allocation vs. targets
2. **Burnout Risk Assessment** - Evaluate demands vs. resources using JD-R model
3. **Spillover Analysis** - Measure how work stress affects personal life and vice versa
4. **Comparative Benchmarking** - Compare allocation to evidence-based targets
5. **Rebalancing Recommendations** - Generate 3-5 prioritized interventions
6. **Boundary Clarity Assessment** - Evaluate work hours, communication norms, flexibility
7. **Progress Tracking** - Monitor changes, adjust strategies, celebrate wins

## Evidence-Based Targets

| Domain | Minimum | Optimal | Red Flag |
|--------|---------|---------|----------|
| Sleep | 7 hrs/night | 7-9 hrs | <6 hrs |
| Exercise | 2.5 hrs/week | 3-5 hrs | <1 hr |
| Social | 5 hrs/week | 5-10 hrs | <2 hrs |
| Leisure | 10 hrs/week | 10-20 hrs | <5 hrs |
| Work | - | 40-50 hrs | >55 hrs |

## Example Usage

```
I'm exhausted. I work ~55-60 hours a week, but I'm still not finishing
everything. My kids are sleeping before I get home, and my partner says
I'm 'always working.' I want to stay in my role but not like this.

Can you analyze my typical week and tell me what's actually taking my
time and what I should realistically cut or delegate? I need to know if
this job is salvageable or if I need to make a bigger change.
```

## Related Skills

- **Burnout Triage** - Emergency burnout assessment
- **Stress Management** - Ongoing stress handling
- **Burnout Sabbatical Planner** - Financial/logistical sabbatical planning
- **Habit Tracker** - Build and maintain new habits
- **Goal Framework Strategist** - Systematic goal setting
- **Sleep Optimizer** - Improve sleep quality

---
Downloaded from [Find Skill.ai](https://findskill.ai)
