---
name: chaotic-boss-script-generator
version: 1.0.0
---

# Initialization

Generate professional scripts for managing disorganized, vague, or reactive managers. Creates paper trail emails, priority-forcing messages, and SBAR updates that establish clarity without seeming insubordinate.

## Structure

```
chaotic-boss-script-generator/
└── SKILL.md          # Main skill prompt (workplace communication specialist)
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r chaotic-boss-script-generator/ ~/.claude/skills/chaotic-boss-script-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant as a system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{boss_persona}}` | `scatterbrain` | Boss archetype: scatterbrain, micromanager, absentee, visionary, gaslighter, hair-on-fire, passive-aggressive |
| `{{urgency_level}}` | `medium` | Task urgency: low, medium, hair_on_fire |
| `{{relationship_tenure}}` | `established` | Tenure with boss: new_hire, established, veteran, rocky |
| `{{communication_channel}}` | `email` | Delivery channel: email, slack, in_person, meeting |
| `{{desired_outcome}}` | `clarity` | Goal: clarity, push_back, deadline_extension, approval, documentation |

## Quick Start

After installing, try these example prompts:

### Clarify a Vague Request
```
My scatterbrain boss just said "fix the presentation" with no details.
Generate a Slack message that offers 3 specific interpretations for her to choose from.
```

### Force Priority Ranking
```
My hair-on-fire boss just assigned me a new "urgent" project, but I already have
3 urgent projects. Generate an email that forces her to pick what I should delay.
```

### Create a Paper Trail
```
I just had a meeting where my boss verbally approved my vacation dates, but he
has a history of forgetting these conversations. Generate a recap email with
negative consent clause.
```

### Push Back on Deadline
```
I was given a 2-week project with a 3-day deadline. Generate a professional email
that presents trade-off options (reduce scope, add resources, or accept quality risk).
```

## Frameworks Used

- **SBAR**: Situation, Background, Assessment, Recommendation (healthcare communication standard)
- **Yes, And**: Agree with the goal, surface the constraint
- **Negative Consent**: "I'll proceed unless I hear otherwise by [date]"
- **Strawman Proposals**: Give concrete options to react to, not open questions
- **Commander's Intent**: Uncover the "why" to make better autonomous decisions

## Boss Persona Quick Reference

| Persona | Key Trait | Script Strategy |
|---------|-----------|-----------------|
| Scatterbrain | No details | Strawman proposals |
| Micromanager | Trust issues | Over-communicate |
| Absentee | Never available | Negative consent |
| Visionary | Big picture only | Translate to specifics |
| Gaslighter | Rewrites history | Heavy documentation |
| Hair-on-Fire | Everything urgent | Force trade-offs |
| Passive-Aggressive | Unclear expectations | Pin down in writing |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
