---
name: probation-survival-plan
version: 1.0.0
description: Transform probation anxiety into a structured 30-60-90 day action plan
author: Find Skill.ai
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
---

# Probation Survival Plan - Initialization

Transform your probation anxiety into a structured 30-60-90 day action plan with milestone tracking, relationship building strategies, and evidence-based anxiety management for new hire success.

## Package Contents

```
probation-survival-plan/
├── SKILL.md          # Main skill prompt (copy this to use)
└── INIT.md           # This initialization file
```

## Quick Start

### For Claude Code Users

```bash
# Copy to your Claude Code skills directory
cp -r probation-survival-plan/ ~/.claude/skills/probation-survival-plan/
```

Then reference in conversations:
```
Use the probation-survival-plan skill to help me create a 30-60-90 day plan for my new job.
```

### For ChatGPT, Gemini, Copilot Users

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Begin your conversation with your probation situation

## Variables

Customize these values based on your situation:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{probation_length}}` | `90` | Total probation period in days (30, 60, 90, 180) |
| `{{current_day}}` | `1` | How many days into probation you currently are |
| `{{role_type}}` | `general` | Role category: tech, customer-facing, remote, leadership, creative |
| `{{anxiety_level}}` | `5` | Current anxiety intensity (1-10 scale) |
| `{{work_environment}}` | `hybrid` | Working arrangement: office, remote, or hybrid |
| `{{prior_job_trauma}}` | `none` | Previous experiences: layoff, firing, toxic environment, or none |

## Example Usage

```
I just started a new software engineering role 2 weeks ago at a startup.
My probation is 90 days and I'm on day 14. I'm working hybrid (3 days in office).
My anxiety is around 7/10 - I keep worrying that my code isn't good enough
and my manager hasn't given me much feedback yet. I was laid off from my
last job 8 months ago so I'm extra nervous about job security.

Help me create a probation survival plan.
```

## What This Skill Provides

1. **Personalized 30-60-90 Day Plan**
   - Week-by-week milestones tailored to your role
   - Specific goals for each phase (Learn → Contribute → Establish)

2. **Relationship Building Map**
   - 8 key relationship categories to develop
   - Suggested timing and approach for each

3. **Win Tracker Template**
   - Weekly documentation structure
   - Evidence collection for reviews

4. **Anxiety Management Toolkit**
   - The STOP method for acute anxiety
   - Intensity-based response protocols
   - Sustainability mantras

5. **Review Preparation Guides**
   - Day 30, 60, and 90 meeting agendas
   - Scripts for difficult conversations
   - Crisis response protocols

6. **Role-Specific Adaptations**
   - Tech roles: code review, shipping code
   - Customer-facing: relationship building focus
   - Remote: communication and visibility strategies
   - Leadership: coalition building approach

## Key Frameworks

### The 30-60-90 Day Framework

| Phase | Days | Focus | Key Activities |
|-------|------|-------|----------------|
| LEARN | 1-30 | Absorb & build foundations | Onboarding, first 1-on-1s, quick wins |
| CONTRIBUTE | 31-60 | Add measurable value | Own projects, expand network |
| ESTABLISH | 61-90 | Demonstrate fit | Significant deliverables, final prep |

### The STOP Method (Anxiety Management)

- **S**eparate fact from fear
- **T**ake one action
- **O**bserve without judgment
- **P**erspective check

### Relationship Categories

1. Direct Manager (weekly)
2. Core Team Members (daily)
3. HR Contact (as needed)
4. IT/Admin Support (as needed)
5. Adjacent Team Colleagues (weekly)
6. Leadership Connection (monthly)
7. Peer in Similar Role (weekly)
8. Informal Advocate (ongoing)

## Common Use Cases

- **Week 1-2 overwhelm**: Breaking down information overload
- **Made a mistake**: Crisis response and recovery
- **No feedback from manager**: Proactively requesting check-ins
- **Imposter syndrome**: Building evidence-based confidence
- **Remote isolation**: Intentional relationship building
- **Pre-review anxiety**: Preparation and documentation

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Manager won't schedule 1-on-1s | Use the provided scripts to request meetings |
| Overwhelmed by tasks | Use the prioritization framework |
| Can't identify quick wins | Review the role-specific suggestions |
| Anxiety keeps increasing | Escalate to professional support |

## Best Practices

1. **Start documenting from Day 1** - Don't wait until review time
2. **Schedule manager meetings proactively** - Don't assume they'll happen
3. **Build relationships intentionally** - Map out 10-12 key connections
4. **Set boundaries early** - Sustainable performance beats burnout
5. **Ask questions freely** - It's expected and shows engagement

## Related Skills

- Impostor Syndrome Reframer
- Stress Management
- Cognitive Reframing Guide
- Performance Review Defender
- Managing Up Coach

---
Downloaded from [Find Skill.ai](https://findskill.ai)
