---
name: toxic-boss-decoder
version: 1.0.0
---

# Initialization

Toxic Boss Decoder is an AI-powered communication analysis tool that evaluates workplace messages to distinguish between intentional psychological manipulation (gaslighting, emotional abuse) and poor management stemming from incompetence, stress, or lack of emotional intelligence. Using Gottman's Four Horsemen framework, NLP sentiment analysis, and attribution theory, this skill empowers employees to understand their experiences, validate their concerns, and make informed decisions about boundaries, HR escalation, or career changes.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive communication analysis instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r toxic-boss-decoder/ ~/.claude/skills/toxic-boss-decoder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant (ChatGPT, Gemini, Copilot, etc.)
4. Begin by sharing a message or situation you'd like analyzed

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Key Features

- **Tone Classification**: Analyzes messages across positive/neutral/negative/toxic spectrum with subcategories (passive-aggressive, contemptuous, stonewalling)
- **Pattern Detection**: Identifies manipulation patterns over time (gaslighting, blame-shifting, silent treatment)
- **Intent Differentiation**: Distinguishes intentional manipulation from poor management/burnout using evidence-based frameworks
- **Gottman's Four Horsemen**: Detects criticism, defensiveness, contempt, and stonewalling patterns
- **Response Strategies**: Provides boundary-setting scripts, documentation templates, and escalation guidance
- **Career Decision Framework**: Helps users evaluate stay/leave decisions based on pattern severity

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{toxicity_threshold}}` | `0.65` | Sentiment score (0-1) for flagging toxic messages |
| `{{pattern_window_days}}` | `30` | Days to aggregate messages for pattern detection |
| `{{gaslighting_likelihood_weight}}` | `0.6` | Weight of gaslighting vs. poor management indicators |
| `{{sarcasm_sensitivity}}` | `0.75` | Sensitivity to passive-aggressive language detection |
| `{{manager_burnout_context_enabled}}` | `true` | Include manager burnout/stress indicators in analysis |
| `{{escalation_trigger_threshold}}` | `4` | Number of red flags required to recommend HR escalation |

## Research Foundation

This skill is based on peer-reviewed research including:
- Gottman's Four Horsemen communication framework
- Simply Psychology's workplace gaslighting guide
- Attribution error research on manager perceptual biases
- NLP sentiment analysis methodologies
- DavidsonMorris legal guide on workplace gaslighting

## Example Usage

```
User: "I just got this message from my manager: 'Interesting take. Well, I think we discussed something similar last month, but sure, let's explore it.' I know we didn't discuss this before. Am I crazy?"

AI Response: [Provides tone classification (passive-aggressive with gaslighting markers), breakdown of each phrase, pattern identification (idea suppression through doubt-creation), severity rating, and questions to assess whether this is isolated or part of a pattern]
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
